//---------------------------------------------------------------------------
#ifndef SerialH
#define SerialH

#include "Buffer.h"

//---------------------------------------------------------------------------
enum TBaudRate{br110=CBR_110,br300=CBR_300,br600=CBR_600,
  br1200=CBR_1200,br2400=CBR_2400,br4800=CBR_4800,br9600=CBR_9600,
  br19200=CBR_19200,br38400=CBR_38400,br56000=CBR_56000,
  br57600=CBR_57600,br115200=CBR_115200,br128000=CBR_128000,
  br256000=CBR_256000};
enum TParity{pEven=EVENPARITY,pMark=MARKPARITY,
  pNo=NOPARITY,pOdd=ODDPARITY};
enum TStopBits{sb10=ONESTOPBIT,sb15=ONE5STOPBITS,
  sb20=TWOSTOPBITS};
enum TByteSize{bs4=4,bs5=5,bs6=6,bs7=7,bs8=8};
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
class TSerial:public TObject{
public:
  __fastcall TSerial(int Number);
  __fastcall ~TSerial();
  void __fastcall setComNumber(int FNumber){this->FNumber = FNumber;};
  int __fastcall WriteString(const AnsiString& String);
  int __fastcall ReadString(AnsiString& String,int Length);
  int __fastcall ReadChar(char* Char);
  int __fastcall WriteChar(const unsigned char byte);
  void __fastcall PurgeInput();
  void __fastcall SetupComm(DWORD InQueue,DWORD OutQueue);
  int __fastcall WriteChar(const unsigned char* bytes, int length);
  int __fastcall WriteCharSlow(const unsigned char* bytes, int length);
  int __fastcall ReadChar(unsigned char* bytes,const int length);
  int __fastcall TSerial::WriteChar(const unsigned char* bytes, int start, int length);
  int __fastcall WriteChar(unsigned char* bytes,const int page_length ,const int page,FILE *file);
  int __fastcall ReadChar(unsigned char* bytes,const int page_length ,const int page);
  int __fastcall writeBuffer(Buffer *buffer);
  int __fastcall readBuffer(Buffer *buffer,int page);
        void Close(void);
          void Open(void);
        void flush();
  __property HANDLE Handle=
    {read=FHandle};
  __property int Number=
    {read=FNumber};
  __property TBaudRate BaudRate=
    {read=GetBaudRate,write=SetBaudRate};
  __property TParity Parity=
    {read=GetParity,write=SetParity};
  __property TStopBits StopBits=
    {read=GetStopBits,write=SetStopBits};
  __property TByteSize ByteSize=
    {read=GetByteSize,write=SetByteSize};
  __property bool CTS={read=GetCTS};
  __property bool DSR={read=GetDSR};
  __property bool RING={read=GetRING};
  __property bool RLSD={read=GetRLSD};
  __property DWORD InputQueue={read=GetInputQueue};
  __property DWORD OutputQueue={read=GetOutputQueue};
  __property DWORD ReadIntervalTimeout=
    {read=GetRIT,write=SetRIT};
  __property DWORD ReadTotalTimeoutMultiplier=
    {read=GetRTTM,write=SetRTTM};
  __property DWORD ReadTotalTimeoutConstant=
    {read=GetRTTC,write=SetRTTC};
  __property DWORD WriteTotalTimeoutMultiplier=
    {read=GetWTTM,write=SetWTTM};
  __property DWORD WriteTotalTimeoutConstant=
    {read=GetWTTC,write=SetWTTC};
  __property bool RTS={write=SetRTS}; 
private:
  bool isOpen;
  HANDLE FHandle;
  int FNumber;
  DCB dcb;
  COMMTIMEOUTS to;
  DWORD EventMask;
  void __fastcall GetDCB();
  void __fastcall SetDCB();
  DWORD __fastcall gms();
  bool __fastcall GetCTS();
  bool __fastcall GetDSR();
  bool __fastcall GetRING();
  bool __fastcall GetRLSD();
  DWORD __fastcall GetInputQueue();
  DWORD __fastcall GetOutputQueue();
  DWORD __fastcall GetRIT();
  DWORD __fastcall GetRTTM();
  DWORD __fastcall GetRTTC();
  DWORD __fastcall GetWTTM();
  DWORD __fastcall GetWTTC();
  void __fastcall SetRIT(DWORD Timeout);
  void __fastcall SetRTTM(DWORD Timeout);
  void __fastcall SetRTTC(DWORD Timeout);
  void __fastcall SetWTTM(DWORD Timeout);
  void __fastcall SetWTTC(DWORD Timeout);
  TBaudRate __fastcall GetBaudRate();
  void __fastcall SetBaudRate(TBaudRate ABaudRate);
  TParity __fastcall GetParity();
  void __fastcall SetParity(TParity AParity);
  TStopBits __fastcall GetStopBits();
  void __fastcall SetStopBits(TStopBits AStopBits);
  TByteSize __fastcall GetByteSize();
  void __fastcall SetByteSize(TByteSize AByteSize);
  void __fastcall SetRTS(bool Status);

  DWORD writeTotalTimeoutMultiplier;
  DWORD writeTotalTimeoutConstant;
  bool rts;
  TBaudRate baudRate;
  TParity parity;
  TStopBits stopBits;
  TByteSize byteSize;
  DWORD readTotalTimeoutConstant;
};

//---------------------------------------------------------------------------
void __fastcall TSerial::SetRTS(bool Status)
{
  EscapeCommFunction(FHandle,
    Status?SETRTS:CLRRTS);
}

#endif
