//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#include <stdio.h>
#pragma hdrstop

#include "Serial.h"

//---------------------------------------------------------------------------
__fastcall TSerial::TSerial(int Number)
{
  FNumber=Number;
  isOpen = false;
  writeTotalTimeoutMultiplier = 200;
  writeTotalTimeoutConstant = 200;
  rts = true;
  baudRate = br4800;//CBR_9600;
  parity = pNo;
  stopBits = sb10;
  byteSize = bs8;
  readTotalTimeoutConstant = 100;
}
//---------------------------------------------------------------------------
void TSerial::Open(void)
{
if(!isOpen){
  char FileName[5];
  sprintf(FileName,"COM%i",FNumber);
  FHandle=CreateFile(FileName,GENERIC_READ|GENERIC_WRITE,
    0,NULL,OPEN_EXISTING,0,NULL);
  if(FHandle==INVALID_HANDLE_VALUE)
    throw Exception(
      AnsiString("Sriov port ")+FileName+" nelze otevt");
  GetDCB();
  SetDCB();
  WriteTotalTimeoutMultiplier = writeTotalTimeoutMultiplier;
  WriteTotalTimeoutConstant = writeTotalTimeoutConstant;
  RTS = rts;
  BaudRate = baudRate;
  Parity = parity;
  StopBits = stopBits;
  ByteSize = byteSize;
  ReadTotalTimeoutConstant = readTotalTimeoutConstant;
  isOpen = true;}
}

//---------------------------------------------------------------------------
__fastcall TSerial::~TSerial()
{
  if(isOpen){
  CloseHandle(FHandle);
  isOpen = false;
  }
}
//---------------------------------------------------------------------------
void __fastcall TSerial::SetupComm(DWORD InQueue,DWORD OutQueue)
{
  ::SetupComm(FHandle,InQueue,OutQueue);
}
//---------------------------------------------------------------------------
DWORD __fastcall TSerial::GetInputQueue()
{
  DWORD d;COMSTAT cs;
  ClearCommError(FHandle,&d,&cs);
  return(cs.cbInQue);
}
//---------------------------------------------------------------------------
DWORD __fastcall TSerial::GetOutputQueue()
{
  DWORD d;COMSTAT cs;
  ClearCommError(FHandle,&d,&cs);
  return(cs.cbOutQue);
}
//---------------------------------------------------------------------------
DWORD __fastcall TSerial::GetRIT()
{
  GetCommTimeouts(FHandle,&to);
  return(to.ReadIntervalTimeout);
}
//---------------------------------------------------------------------------
DWORD __fastcall TSerial::GetRTTM()
{
  GetCommTimeouts(FHandle,&to);
  return(to.ReadTotalTimeoutMultiplier);
}
//---------------------------------------------------------------------------
DWORD __fastcall TSerial::GetRTTC()
{
  GetCommTimeouts(FHandle,&to);
  return(to.ReadTotalTimeoutConstant);
}
//---------------------------------------------------------------------------
DWORD __fastcall TSerial::GetWTTM()
{
  GetCommTimeouts(FHandle,&to);
  return(to.WriteTotalTimeoutMultiplier);
}
//---------------------------------------------------------------------------
DWORD __fastcall TSerial::GetWTTC()
{
  GetCommTimeouts(FHandle,&to);
  return(to.WriteTotalTimeoutConstant);
}
//---------------------------------------------------------------------------
void __fastcall TSerial::SetRIT(DWORD Timeout)
{
  GetCommTimeouts(FHandle,&to);
  to.ReadIntervalTimeout=Timeout;
  SetCommTimeouts(FHandle,&to);
}
//---------------------------------------------------------------------------
void __fastcall TSerial::SetRTTM(DWORD Timeout)
{
  GetCommTimeouts(FHandle,&to);
  to.ReadTotalTimeoutMultiplier=Timeout;
  SetCommTimeouts(FHandle,&to);
}
//---------------------------------------------------------------------------
void __fastcall TSerial::SetRTTC(DWORD Timeout)
{
  GetCommTimeouts(FHandle,&to);
  to.ReadTotalTimeoutConstant=Timeout;
  SetCommTimeouts(FHandle,&to);
}
//---------------------------------------------------------------------------
void __fastcall TSerial::SetWTTM(DWORD Timeout)
{
  GetCommTimeouts(FHandle,&to);
  to.WriteTotalTimeoutMultiplier=Timeout;
  SetCommTimeouts(FHandle,&to);
}
//---------------------------------------------------------------------------
void __fastcall TSerial::SetWTTC(DWORD Timeout)
{
  GetCommTimeouts(FHandle,&to);
  to.WriteTotalTimeoutConstant=Timeout;
  SetCommTimeouts(FHandle,&to);
}
//---------------------------------------------------------------------------
int __fastcall TSerial::WriteString(const AnsiString& String)
{
  DWORD w;
  WriteFile(FHandle,String.c_str(),String.Length(),&w,NULL);
  return(w);
}
//---------------------------------------------------------------------------

int __fastcall TSerial::writeBuffer(Buffer *buffer){
  DWORD w;
  //char* buf = buffer->getBuffer();
  int length = buffer->getLength();
  char c;
  for(int i=0;i<length;i++){
  Sleep(10);
  c = buffer->operator [](i);
  WriteFile(FHandle,&c,1,&w,NULL);
  }
  return(w);
}
//---------------------------------------------------------------------------
  int __fastcall TSerial::WriteCharSlow(const unsigned char* bytes, int length){
  DWORD w;
  char c;
  for(int i=0;i<length;i++){
        Sleep(1);
        c = bytes[i];
        WriteFile(FHandle,&c,1,&w,NULL);
        }
  return(w);
  }
//---------------------------------------------------------------------------
  int __fastcall TSerial::WriteChar(const unsigned char* bytes, int start, int length){
  DWORD w;
  char c;
  int end = start + length;
  for(int i=start;i<end;i++){
        Sleep(3);
        c = bytes[i];
        WriteFile(FHandle,&c,1,&w,NULL);
        Sleep(3);
        }
  return(w);
  }
//---------------------------------------------------------------------------
int __fastcall TSerial::readBuffer(Buffer *buffer,int page){
  DWORD r;
  //WriteFile(FHandle,buffer->getBuffer(),buffer->getLength(),&r,NULL);
  writeBuffer(buffer);
  char buf[256];
//  ReadFile(FHandle,buffer->getBuffer(),buffer->getLength(),&r,NULL);
  for(int i=0;i<buffer->getLength();i++){
        buf[i] = buffer->operator [](i+256*page);
  }
  ReadFile(FHandle,buf,256,&r,NULL);
  return r;

}
//---------------------------------------------------------------------------

int __fastcall TSerial::WriteChar(const unsigned char* bytes, int length)
{
  DWORD w;
  WriteFile(FHandle,bytes,length,&w,NULL);
  return(w);
}
//---------------------------------------------------------------------------
int __fastcall TSerial::WriteChar(const unsigned char byte)
{
  DWORD w;
  WriteFile(FHandle,&byte,1,&w,NULL);
  return(w);
}
//---------------------------------------------------------------------------
int __fastcall TSerial::WriteChar(unsigned char* bytes,const int page_length ,const int page,FILE *file){
  DWORD w;
  WriteFile(FHandle,(bytes+page_length*page),page_length,&w,NULL);
  if(file!=0){
          fwrite((bytes+page_length*page),sizeof(unsigned char),page_length,file);
  }
  return(w);
}
//---------------------------------------------------------------------------
int __fastcall TSerial::ReadChar(unsigned char* bytes,const int page_length ,const int page){
  DWORD r;
  //char c[356];
  WriteFile(FHandle,(bytes+page_length*page),page_length,&r,NULL);
  //ReadFile(FHandle,c,page_length,&r,NULL);
  ReadFile(FHandle,(bytes+page_length*page),page_length,&r,NULL);
  //ReadFile(FHandle,(bytes),page_length,&r,NULL);
  return r;
}
//---------------------------------------------------------------------------
int __fastcall TSerial::ReadChar(unsigned char* bytes,const int length){
  DWORD r;
  ReadFile(FHandle,bytes,length,&r,NULL);
  return r;
}
//---------------------------------------------------------------------------
int __fastcall TSerial::ReadString(AnsiString& String,int Length)
{
  DWORD r;
  char *str=new char[Length+1];
  ReadFile(FHandle,str,Length,&r,NULL);
  str[r]='\0';
  String=str;
  delete[]str;
  return(r);
}

//---------------------------------------------------------------------------
int __fastcall TSerial::ReadChar(char* Char)
{
  DWORD r;
  ReadFile(FHandle,Char,1,&r,NULL);
  return(r);
}
//---------------------------------------------------------------------------
void __fastcall TSerial::PurgeInput()
{
  PurgeComm(FHandle,PURGE_RXCLEAR);
}
//---------------------------------------------------------------------------
void __fastcall TSerial::GetDCB()
{
  GetCommState(FHandle,&dcb);
}
//---------------------------------------------------------------------------
void __fastcall TSerial::SetDCB()
{
  dcb.fAbortOnError=TRUE;
  SetCommState(FHandle,&dcb);
}
//---------------------------------------------------------------------------
TBaudRate __fastcall TSerial::GetBaudRate()
{
  GetDCB();
  return((TBaudRate)dcb.BaudRate);
}
//---------------------------------------------------------------------------
void __fastcall TSerial::SetBaudRate(TBaudRate ABaudRate)
{
  GetDCB();
  dcb.BaudRate=ABaudRate;
  SetDCB();
}
//---------------------------------------------------------------------------
TParity __fastcall TSerial::GetParity()
{
  GetDCB();
  return((TParity)dcb.Parity);
}
//---------------------------------------------------------------------------
void __fastcall TSerial::SetParity(TParity AParity)
{
  GetDCB();
  dcb.Parity=AParity;
  SetDCB();
}
//---------------------------------------------------------------------------
TStopBits __fastcall TSerial::GetStopBits()
{
  GetCommState(FHandle,&dcb);
  return((TStopBits)dcb.StopBits);
}
//---------------------------------------------------------------------------
void __fastcall TSerial::SetStopBits(TStopBits AStopBits)
{
  GetDCB();
  dcb.StopBits=AStopBits;
  SetDCB();
}
//---------------------------------------------------------------------------
TByteSize __fastcall TSerial::GetByteSize()
{
  GetDCB();
  return((TByteSize)dcb.ByteSize);
}
//---------------------------------------------------------------------------
void __fastcall TSerial::SetByteSize(TByteSize AByteSize)
{
  GetDCB();
  dcb.ByteSize=AByteSize;
  SetDCB();
}
//---------------------------------------------------------------------------
DWORD __fastcall TSerial::gms()
{
  DWORD d;
  GetCommModemStatus(FHandle,&d);
  return(d);
}
//---------------------------------------------------------------------------
bool __fastcall TSerial::GetCTS()
{
  return(gms()&MS_CTS_ON);
}
//---------------------------------------------------------------------------
bool __fastcall TSerial::GetDSR()
{
  return(gms()&MS_DSR_ON);
}
//---------------------------------------------------------------------------
bool __fastcall TSerial::GetRING()
{
  return(gms()&MS_RING_ON);
}
//---------------------------------------------------------------------------
bool __fastcall TSerial::GetRLSD()
{
  return(gms()&MS_RLSD_ON);
}

//---------------------------------------------------------------------------
void TSerial::Close(void)
{
  if(isOpen){
  CloseHandle(FHandle);
  isOpen = false;
        }
}

