//---------------------------------------------------------------------------

#ifndef MainFormH
#define MainFormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>

#include "Serial.h"
#include "AT89S51.h"
#include "AT89S52.h"
#include "Buffer.h"
#include "AT89S5xRunnable.h"

#include <Dialogs.hpp>
#include <Menus.hpp>
#include <ComCtrls.hpp>
#include <ExtCtrls.hpp>
#include "CGAUGES.h"



#define BINFILENAME_CMD_ID 0
#define UPROCTYPE_CMD_ID 1
#define NO_CMD_ID -1

#define BINFILENAME_CMD "-binfile"
#define UPROCTYPE_CMD "-uproctype"

//---------------------------------------------------------------------------
class TProgForm : public TForm
{
__published:	// IDE-managed Components
        TMainMenu *MainMenu1;
        TMenuItem *itemFile;
        TMenuItem *itemOpen;
        TOpenDialog *OpenDialog;
        TStatusBar *StatusBar;
        TMenuItem *itemDevice;
        TMenuItem *ItemAT89S51;
        TMenuItem *ItemAT89S52;
        TPanel *Panel1;
        TGroupBox *GroupBox1;
        TEdit *Edit1;
        TEdit *Edit2;
        TEdit *Edit3;
        TButton *btnProgram;
        TButton *btnRead;
        TLabel *Label1;
        TLabel *Label2;
        TLabel *Label3;
        TButton *btnReadSig;
        TButton *btnLockBits;
        TGroupBox *GroupBox2;
        TCheckBox *CheckBox1;
        TCheckBox *CheckBox2;
        TCheckBox *CheckBox3;
        TCheckBox *cbRwLockBits;
        TButton *Button1;
        TCGauge *CGauge1;
        TMenuItem *itemSave;
        TSaveDialog *SaveDialog;
        TMenuItem *port1;
        void __fastcall btnReadSigClick(TObject *Sender);
        void __fastcall btnLockBitsClick(TObject *Sender);
        void __fastcall itemOpenClick(TObject *Sender);
        void __fastcall btnProgramClick(TObject *Sender);
        void __fastcall btnReadClick(TObject *Sender);
        void __fastcall DeviceSelectClick(TObject *Sender);
        void __fastcall cbRwLockBitsClick(TObject *Sender);
        void __fastcall Button1Click(TObject *Sender);
        void __fastcall FormClose(TObject *Sender, TCloseAction &Action);
        void __fastcall itemSaveClick(TObject *Sender);
        void __fastcall menuItemClick(TObject *Sender);
        
private:	// User declarations
        TMenuItem *selectedDevice;
        TSerial *serial;
        Buffer *loadedBuffer;
        AT89S5X *prog;
        int TProgForm::getCommandId(AnsiString sParam);
        AT89S5xRunnable *at89s5XRunnable;

        TMenuItem *selectedMenuItem;

public:		// User declarations
        __fastcall TProgForm(TComponent* Owner);
        virtual __fastcall ~TProgForm();
protected:
        void ProcessProgramParameters(void);
        void SetDevice(int deviceId);
        void LoadFile(AnsiString fileName);
        void ReadSignatureFinish(void);
        void EnableAll(bool enable);
        void virtual __fastcall ReceiveMessage(TMessage & msg);        
        BEGIN_MESSAGE_MAP
        MESSAGE_HANDLER(USER_MESSAGE,TMessage,ReceiveMessage)
        END_MESSAGE_MAP(TForm)
};
//---------------------------------------------------------------------------
extern PACKAGE TProgForm *ProgForm;
//---------------------------------------------------------------------------
#endif
