//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "MainForm.h"
#include "progressconst.h"
#include "globalconst.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "CGAUGES"
#pragma resource "*.dfm"
TProgForm *ProgForm;
//---------------------------------------------------------------------------
__fastcall TProgForm::TProgForm(TComponent* Owner)
        : TForm(Owner)
{
        prog = 0;
        at89s5XRunnable = 0;
        selectedDevice = 0;
        serial = new TSerial(1);
        SetDevice(DEV_AT89S51);
        ItemAT89S51->Tag = DEV_AT89S51;
        ItemAT89S52->Tag = DEV_AT89S52;
        loadedBuffer = 0;
        ProcessProgramParameters();
        /**************************/
        //prog = new AT89S52(*serial);
        int i = 1;
        TMenuItem *mi;
        mi = new TMenuItem(port1);
        mi->Caption = "COM "+IntToStr(i);
        mi->OnClick = menuItemClick;
        mi->Checked = true;
        mi->Tag = i;
        selectedMenuItem = mi;
        port1->Add(mi);
        for(i = 2;i<9;i++){
                mi = new TMenuItem(port1);
                mi->Caption = "COM "+IntToStr(i);
                port1->Add(mi);
                mi->OnClick = menuItemClick;
                mi->Tag = i;
                }
                char *c = new char[1000];
                for(int i=0;i<1000;i++){
                        c[i] = i&1;
                }
                delete c;
}
//---------------------------------------------------------------------------
void __fastcall TProgForm::menuItemClick(TObject *Sender){
        TMenuItem *menuItem = (TMenuItem*)Sender;
        menuItem->Checked = true;
        selectedMenuItem->Checked = false;
        selectedMenuItem = menuItem;
        serial->setComNumber(menuItem->Tag);
};
//---------------------------------------------------------------------------
void __fastcall TProgForm::btnReadSigClick(TObject *Sender)
{
        try{    EnableAll(false);
                at89s5XRunnable->ReadSignature();
                }
        catch(Exception &ex){
        ShowMessage("error");
       }
}
//---------------------------------------------------------------------------

__fastcall TProgForm::~TProgForm()
{
  delete at89s5XRunnable;
  delete prog;
  delete serial;
  delete loadedBuffer;

}
//---------------------------------------------------------------------------
void __fastcall TProgForm::btnLockBitsClick(TObject *Sender)
{ char lockBits = 0;
  if(cbRwLockBits->Checked){
        if(CheckBox1->Checked){
                lockBits |= LOCK_BIT_1;
       }
        if(CheckBox2->Checked){
                lockBits |= LOCK_BIT_2;
       }
       prog->WriteLockBits(lockBits);
  }
  else{
         lockBits = prog->ReadLockBits();
         if(lockBits & LOCK_BIT_1){
                CheckBox1->Checked = true;
                }
         else{
                CheckBox1->Checked = false;
                }
        if(lockBits & LOCK_BIT_2){
                CheckBox1->Checked = true;
                }
        else{
                CheckBox1->Checked = false;
                }
        if(lockBits & LOCK_BIT_3){
                CheckBox1->Checked = true;
                }
        else{
                CheckBox1->Checked = false;
                }
   }
}
//---------------------------------------------------------------------------

void __fastcall TProgForm::itemOpenClick(TObject *Sender)
{
        if(OpenDialog->Execute()){
                LoadFile(OpenDialog->FileName);
        }
}
//---------------------------------------------------------------------------

void __fastcall TProgForm::btnProgramClick(TObject *Sender)
{
        if(loadedBuffer){
        at89s5XRunnable->WriteProgramMemoryPage(*loadedBuffer);
        }
}
//---------------------------------------------------------------------------

void __fastcall TProgForm::btnReadClick(TObject *Sender)
{
        //prog->ReadProgramMemoryPage();
        EnableAll(false);
        at89s5XRunnable->ReadProgramMemoryPage();
}
//---------------------------------------------------------------------------

void __fastcall TProgForm::DeviceSelectClick(TObject *Sender)
{
   TMenuItem *menuItem = (TMenuItem*)Sender;
   selectedDevice->Checked = false;
   menuItem->Checked = true;
   selectedDevice = menuItem;
   SetDevice(menuItem->Tag);

}
//---------------------------------------------------------------------------

void __fastcall TProgForm::cbRwLockBitsClick(TObject *Sender)
{
   TCheckBox *cb = (TCheckBox*)Sender;

   if(cb->Checked){
        CheckBox1->Enabled = true;
        CheckBox2->Enabled = true;
        CheckBox3->Enabled = true;
        btnLockBits->Caption = "Write Lock Bits";
        }
   else{
        CheckBox1->Enabled = false;
        CheckBox2->Enabled = false;
        CheckBox3->Enabled = false;
        btnLockBits->Caption = "Read Lock Bits";
   }
}
//---------------------------------------------------------------------------


void __fastcall TProgForm::Button1Click(TObject *Sender)
{

at89s5XRunnable->ReadProgramMemoryPage();

}
//---------------------------------------------------------------------------

void __fastcall TProgForm::FormClose(TObject *Sender, TCloseAction &Action)
{
 if(at89s5XRunnable){
        at89s5XRunnable->stop();
        }
  while(at89s5XRunnable->isRunning()){
  };
}
//---------------------------------------------------------------------------

void __fastcall TProgForm::ReceiveMessage(TMessage & msg)
{
        int progress = msg.WParam;
        int status = msg.LParam;

        switch(status){
        case USER_MESSAGE_PROGRESS:
                this->CGauge1->Progress = progress;
                break;
        case USER_MESSAGE_FINISH:
                EnableAll(true);
                break;
        case USER_MESSAGE_READ_SIGNATURE_DONE:
                ReadSignatureFinish();
                EnableAll(true);                
                break;
        case USER_MESSAGE_MEMORY_READ_DONE:
                itemSave->Enabled = true;
                break;
        default:
                break;
        }
}
//---------------------------------------------------------------------------

void TProgForm::ProcessProgramParameters(void)
{
        AnsiString str= " - ";
        AnsiString deviceType;
        ParamCount();
        int last_cmd = NO_CMD_ID;
        for (int i=0;i<=ParamCount();i++){
             switch(last_cmd){
                case BINFILENAME_CMD_ID:
                        //fileName = new char[ParamStr(i).Length()+1];
                        //strcpy(fileName,ParamStr(i).c_str());
                        LoadFile(ParamStr(i).c_str());
                        last_cmd = NO_CMD_ID;
                        break;
                case UPROCTYPE_CMD_ID:
                        deviceType = ParamStr(i).c_str();
                        if(deviceType == "AT89S51"){
                          SetDevice(DEV_AT89S51);
                        }
                        if(deviceType == "AT89S52"){
                          SetDevice(DEV_AT89S52);
                        }
                        //uprocType = new char[ParamStr(i).Length()+1];
                        //strcpy(uprocType,ParamStr(i).c_str());
                        last_cmd = NO_CMD_ID;
                        break;
                default:
                        last_cmd = getCommandId(ParamStr(i));
                        break;
                }

         }
}
//---------------------------------------------------------------------------
int TProgForm::getCommandId(AnsiString sParam)
{
     if(sParam == BINFILENAME_CMD){
             return BINFILENAME_CMD_ID;
        }
     if(sParam == UPROCTYPE_CMD){
             return UPROCTYPE_CMD_ID;
        }
        return NO_CMD_ID;
}
//---------------------------------------------------------------------------

void TProgForm::SetDevice(int deviceId)
{
        if(selectedDevice){
        selectedDevice->Checked = false;
        }
        delete prog;
        switch(deviceId){
        case DEV_AT89S52:
                prog = new AT89S52(*serial);
                selectedDevice = ItemAT89S52;
                break;
        default:
                selectedDevice = ItemAT89S51;
                prog = new AT89S51(*serial);
                break;
        }
        selectedDevice->Checked = true;
        if(at89s5XRunnable == 0){
        at89s5XRunnable = new AT89S5xRunnable(this->prog,this);}
        else{
        at89s5XRunnable->at89S5X = this->prog;
        ProcessListener *pl = (ProcessListener*)at89s5XRunnable;
        prog->setProcListener(pl);
        }
}
//---------------------------------------------------------------------------
void TProgForm::LoadFile(AnsiString fileName)
{
        try{
        FILE *loadedFile;
        loadedFile = fopen(fileName.c_str(),"rb");
        StatusBar->SimpleText = fileName;
        unsigned int length = prog->getMemoryLength();
        if(!loadedBuffer){
                loadedBuffer = new Buffer(length);
        }
        //unsigned char *bf = loadedBuffer->getBuffer();
        loadedBuffer->loadFromFile(loadedFile,length);
        //fread(bf,sizeof(char),length,loadedFile);
        fclose(loadedFile);
        }
        catch(Exception &ex){
          ShowMessage(ex.Message);
        }

}
//---------------------------------------------------------------------------
void TProgForm::ReadSignatureFinish(void)
{
   int sign = at89s5XRunnable->readSignature;
   Edit1->Text = IntToHex(sign & 0xFF,2);
   Edit2->Text = IntToHex((sign>>8) & 0xFF,2);
   Edit3->Text = IntToHex((sign>>16) & 0xFF,2);
}
//---------------------------------------------------------------------------
void TProgForm::EnableAll(bool enable)
{
this->itemFile->Enabled = enable;
this->itemDevice->Enabled = enable;
this->btnProgram->Enabled = enable;
this->btnRead->Enabled = enable;
this->btnReadSig->Enabled = enable;
this->btnLockBits->Enabled = enable;
}
//---------------------------------------------------------------------------
void __fastcall TProgForm::itemSaveClick(TObject *Sender)
{
        if(SaveDialog->Execute()){
            AnsiString fileName = SaveDialog->FileName;
            Buffer* buf = at89s5XRunnable->getMemoryBuffer();
            if(buf!=0){
                buf->saveToFile(fileName.c_str());
            }
        }
}
//---------------------------------------------------------------------------

