//---------------------------------------------------------------------------

#ifndef AT89S5xRunnableH
#define AT89S5xRunnableH

#include "AT89S5X.h"
#include "ProcessListener.h"

#define USER_MESSAGE WM_USER+1


//---------------------------------------------------------------------------
class AT89S5xRunnable : ProcessListener {

private:
        bool onReadProgramMemoryPage;
        bool onWriteProgramMemoryPage;
        bool onReadSignature;        
        bool onRun;
        TForm *owner;
        Buffer *buf;

public:
        AT89S5X *at89S5X;
        AT89S5xRunnable(AT89S5X *at89S5X, TForm *owner);

        virtual __fastcall ~AT89S5xRunnable();        
        char ReadProgramMemoryPage(void);
        void WriteProgramMemoryPage(Buffer &buf);
        bool isRunning(void){return onRun;}
        void stop(){onRun =  false;
                    Resume();
                    }
        void ReadSignature(void);
        int readSignature;
        Buffer* getMemoryBuffer(void){return buf;}
protected:
        virtual void __fastcall Execute(void);
        virtual void SendProgressMessage(int progress, int status);
};
#endif
