//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "AT89S5xRunnable.h"
#include "progressconst.h"

//---------------------------------------------------------------------------

#pragma package(smart_init)
AT89S5xRunnable::AT89S5xRunnable(AT89S5X *at89S5X, TForm *owner) : ProcessListener(true)
{
        this->at89S5X = at89S5X;
        //this->at89S5X->ProgressMessage = &SendProgressMessage;
        this->owner = owner;
        this->at89S5X->setProcListener(this);
        onRun = true;
        onReadProgramMemoryPage = false;
        onWriteProgramMemoryPage = false;
        onReadSignature = false;
}
//---------------------------------------------------------------------------
__fastcall AT89S5xRunnable::~AT89S5xRunnable()
{
        //TODO: Add your source code here
}
//---------------------------------------------------------------------------
void __fastcall AT89S5xRunnable::Execute(void)
{
        while(onRun){

        if(onReadProgramMemoryPage){
           at89S5X->ReadProgramMemoryPage();
           buf = at89S5X->getMemoryBuffer();
           onReadProgramMemoryPage = false;
           SendProgressMessage(100,USER_MESSAGE_PROGRESS);
           SendProgressMessage(100,USER_MESSAGE_MEMORY_READ_DONE);
        }
        if(onWriteProgramMemoryPage){
          at89S5X->WriteProgramMemoryPage(*buf);
          onWriteProgramMemoryPage = false;
          SendProgressMessage(100,USER_MESSAGE_PROGRESS);
          SendProgressMessage(100,USER_MESSAGE_MEMORY_READ_DONE);
        }
        if(onReadSignature){
         readSignature = at89S5X->ReadSignature();
         onReadSignature = false;
         SendProgressMessage(0,USER_MESSAGE_READ_SIGNATURE_DONE);
        }
        if(onRun){
        this->Suspend();}
        }
}
//---------------------------------------------------------------------------
char AT89S5xRunnable::ReadProgramMemoryPage(void){
   onReadProgramMemoryPage = true;
   this->Resume();
   return 0;
}
//---------------------------------------------------------------------------
void AT89S5xRunnable::WriteProgramMemoryPage(Buffer &buf){
   this->buf = &buf;
   onWriteProgramMemoryPage = true;
   this->Resume();
}
//---------------------------------------------------------------------------

void AT89S5xRunnable::SendProgressMessage(int progress, int status)
{
 PostMessage(owner->Handle,(UINT)USER_MESSAGE,(WPARAM)progress,(LPARAM)status);
 }
//---------------------------------------------------------------------------
void AT89S5xRunnable::ReadSignature(void){
        onReadSignature = true;
        this->Resume();
}
//---------------------------------------------------------------------------

