//---------------------------------------------------------------------------

#ifndef AT89S5XH
#define AT89S5XH

#include "Serial.h"
#include "ProcessListener.h"

#define AT89S5X_WRITE_PAGE 0x50
#define AT89S5X_READ_PAGE 0x30

#define PAGE_SIZE 256

#define LOCK_BIT_1 0x1
#define LOCK_BIT_2 0x2
#define LOCK_BIT_3 0x4
//---------------------------------------------------------------------------
class AT89S5X{

private:
        TSerial & serial;
        Buffer *memoryBuf;
        unsigned char *pageBuf;
        ProcessListener *procListener;
protected:

        void Init(void);
        unsigned int pages;
public:
        void setProcListener(ProcessListener *procListener){
                this->procListener = procListener;
        }
        //void ( __closure *ProgressMessage )(int,int);
        int ReadSignature(void);
        char ReadLockBits(void);
        virtual unsigned int getMemoryLength(void) = 0;
        __fastcall AT89S5X(TSerial & serial);
        ~AT89S5X();
        void ProgrammingEnable(void);
        void ChipErase(void);
        char ReadProgramMemoryByte(unsigned int adr);
        void WriteProgramMemoryByte(unsigned int adr,unsigned char byte);
        void ReadProgramMemoryPage(void);
        void WriteProgramMemoryPage(Buffer &buf);
        void WriteLockBits(char lockBits);
        Buffer* getMemoryBuffer(){return memoryBuf;}
        };
#endif
