//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "AT89S5X.h"
#include "progressconst.h"

//---------------------------------------------------------------------------

#pragma package(smart_init)

//---------------------------------------------------------------------------
__fastcall AT89S5X::AT89S5X(TSerial & serial) : serial(serial)
{
procListener = 0;
}
//---------------------------------------------------------------------------
void AT89S5X::ProgrammingEnable(void)
{       char c;
        serial.Open();
        serial.RTS = false;
        Sleep(600);
        serial.RTS = true;
        Sleep(600);
        serial.WriteChar(0xAC);
        serial.ReadChar(&c);
        serial.WriteChar(0x53);
        serial.ReadChar(&c);
        serial.WriteChar(0x0);
        serial.ReadChar(&c);
        serial.WriteChar(0x69);
        serial.ReadChar(&c);
        Sleep(600);
}
//---------------------------------------------------------------------------
void AT89S5X::ChipErase(void)
{       char c;
        Sleep(1000);
        serial.WriteChar(0xAC);
        serial.WriteChar(0x80);
        serial.WriteChar(0x0);
        serial.WriteChar(0xAC);
        Sleep(1000);
}
//---------------------------------------------------------------------------
char AT89S5X::ReadProgramMemoryByte(unsigned int adr)
{       char c = adr>>8;
        serial.WriteChar(0x20);
        serial.WriteChar(c);
        c = adr;
        serial.WriteChar(c);
        serial.WriteChar(0x0);
        serial.ReadChar(&c);
        return c;
}
//---------------------------------------------------------------------------
void AT89S5X::WriteProgramMemoryByte(unsigned int adr,unsigned char byte)
{       char c = adr>>8;
        serial.WriteChar(0x40);
        serial.WriteChar(c);
        c = adr;
        serial.WriteChar(c);
        serial.WriteChar(byte);
}
//---------------------------------------------------------------------------
void AT89S5X::WriteLockBits(char lockBits)
{       unsigned char wc = 0xE0;
        char c;
        serial.Open();
        if(lockBits & LOCK_BIT_1){
           wc |= 0x2;
        }
        if(lockBits & LOCK_BIT_2){
          wc |= 0x1;
        }
        ProgrammingEnable();
        serial.WriteChar(0xAC);
        Sleep(2);
        serial.ReadChar(&c);
         Sleep(2);
        serial.WriteChar(wc);
        Sleep(2);
        serial.ReadChar(&c);
        Sleep(2);
        serial.WriteChar(0x0);
        Sleep(2);
        serial.ReadChar(&c);
        Sleep(2);
        serial.WriteChar(0x0);
        Sleep(2);
        serial.ReadChar(&c);
        serial.Close();
}
//---------------------------------------------------------------------------
void AT89S5X::ReadProgramMemoryPage(void){
        FILE *file = fopen("readed_memory.bin","wb");
        char c;
        float progress =  100.0/((float)this->pages);
        serial.Open();
        ProgrammingEnable();
        if(!memoryBuf){
                memoryBuf = new Buffer(getMemoryLength());
        }
        for(unsigned int page=0;page<pages;page++){
          c = AT89S5X_READ_PAGE;
          serial.WriteChar(c);
          serial.ReadChar(&c);
          c = 0xFF & page;
          serial.WriteChar(c);
          serial.ReadChar(&c);
          c = 0;
          for(int i=0;i<PAGE_SIZE;i++){
           serial.WriteChar(c);
           serial.ReadChar(&c);
           fwrite(&c,sizeof(char),1,file);
           memoryBuf->operator [](i+PAGE_SIZE*page) = c;
          }
          procListener->SendProgressMessage((int)((float)page*progress),USER_MESSAGE_PROGRESS);

        }
        procListener->SendProgressMessage(100,PROGRESS_FINISH);
        serial.Close();
        fclose(file);
}
//---------------------------------------------------------------------------
void AT89S5X::WriteProgramMemoryPage(Buffer &buf){
        FILE *file = fopen("writed_memory.bin","wb");
        char c;
        float progress =  100.0/((float)this->pages);
        serial.SetupComm(getMemoryLength()+10,getMemoryLength()+10);
        serial.Open();
        serial.SetupComm(getMemoryLength()+10,getMemoryLength()+10);        
        ProgrammingEnable();
        ChipErase();
        for(unsigned int page=0;page<pages;page++){
          c = AT89S5X_WRITE_PAGE;
          serial.WriteChar(c);
          serial.ReadChar(&c);
          c = 0xFF & page;
          serial.WriteChar(c);
          serial.ReadChar(&c);
          for(int i=0;i<PAGE_SIZE;i++){
           c = buf[i+PAGE_SIZE*page];
           fwrite(&c,sizeof(char),1,file);
           Sleep(1);
           serial.WriteChar(c);
           Sleep(1);
           serial.ReadChar(&c);
          }
          procListener->SendProgressMessage((int)((float)page*progress),USER_MESSAGE_PROGRESS);
        }
        serial.Close();
        procListener->SendProgressMessage(100,PROGRESS_FINISH);
        fclose(file);
}
//---------------------------------------------------------------------------
AT89S5X::~AT89S5X()
{
  delete memoryBuf;
  delete pageBuf;
}
//---------------------------------------------------------------------------
void AT89S5X::Init(void)
{
   unsigned int memoryLength = getMemoryLength();
   unsigned int pages = memoryLength/PAGE_SIZE;
   this->pages = pages;
   memoryBuf = new Buffer(memoryLength);
   pageBuf = new unsigned char[PAGE_SIZE+2];

}
//---------------------------------------------------------------------------
int AT89S5X::ReadSignature(void)
{       char c;
        unsigned char res[3];
        unsigned char adr[] = {0x0,0x1,0x2};
        ProgrammingEnable();
        serial.Open();
        for(int i=0;i<3;i++){
                serial.WriteChar(0x28);
                serial.ReadChar(&c);

                serial.WriteChar(adr[i]);
                serial.ReadChar(&c);

                serial.WriteChar(0x0);
                serial.ReadChar(&c);

                serial.WriteChar(0x0);
                serial.ReadChar(&c);
                res[i] = c;
                }
        int iRes = res[0] | res[1]<<8 | res[3]<<16;
        serial.Close();
        procListener->SendProgressMessage(100,USER_MESSAGE_PROGRESS);
        return iRes;

}
//---------------------------------------------------------------------------
char AT89S5X::ReadLockBits(void)
{       char c = 0;
        serial.Open();

        ProgrammingEnable();

        serial.WriteChar(0x24);
        serial.ReadChar(&c);

        serial.WriteChar(0x0);
        serial.ReadChar(&c);

        serial.WriteChar(0x0);
        serial.ReadChar(&c);

        c>>=2;
        serial.Close();
        return c;
}
//---------------------------------------------------------------------------
