	#include <Reg2051.h>
	#include <uart.h>

	#define ON_RESET 0x1	
	#define ON_TEST 0x2	
	#define ON_RECEIVE 0x4	

	#define SMOD_   0x80
	
	sbit EN = P3 ^ 0x7;
	sbit DIR = P3 ^ 0x5;
	sbit MODE = P3 ^ 0x4;
	sbit CTS  = P3 ^ 0x2;
	sbit RSTX = P3 ^ 0x3;
	
	sbit SCK = P1 ^ 0x0;
	sbit MOSI = P1 ^ 0x1;
	sbit RST = P1 ^ 0x2;
	sbit MISO = P1 ^ 0x5;

	sbit OUT_0 = P1 ^ 0x3;
	sbit OUT_1 = P1 ^ 0x4;
	sbit IN_0 = P1 ^ 0x6;
	sbit IN_1 = P1 ^ 0x7;

    char status;
	
	char CLK = 0;
	char uart_receive_byte;

/*************************************************************************/    
	void uart_receive(void){
	if(ON_RECEIVE&&status){
			OUT_1 = 0;}
	uart_receive_byte = SBUF;		
	RI = 0;
	status |= ON_RECEIVE;
	}
/*************************************************************************/    
	void uart_trancieve(void){
	TI = 0;
	}
/*************************************************************************/    

	void uartEvent(void) interrupt 4 using 2 {
	
	if(RI){	
	uart_receive();
	}

	if(TI){
	 uart_trancieve();
	}	 
	}

/*************************************************************************/    
	void init_uart(void){	
	SM0 = 0;
	SM1 = 1;
    PCON = PCON | SMOD_;
	TH1 = BR_4800;
	TMOD = 0x20;
	TR1 = 1;
	ES = 1;
	REN = 1;
	EA = 1;
	}
/*************************************************************************/    
	void init(void){
	P1 = 0xAA;
	P3 = 0xFF;
	TMOD = 0x10;
	init_uart();	
	}
/*************************************************************************/
		void wait(int i){
			while(i!=0){
			i--;
			}
		}
/*************************************************************************/
	  char sendByte(char out){
	  	unsigned char mask = 0x80;		
		char in = 0x0;
		wait(4);
		while(mask){
			SCK = 0;
			wait(4);
			MOSI = mask & out;
			if(MISO){
				in |= mask;}  
			wait(4);	
			SCK = 1;	
			wait(4);			
			SCK = 0;
			mask>>=1;
			}
		return in;
	  }
/*************************************************************************/
	  int main(void){	     	  	 
		 char output;	 
		 char input;
		 char tmp;
		 status = 0;	
		 init();
		 OUT_1 = 1;	
		 
		 while(1){
		 	// output enable settting
		 	if(RSTX){
		 		if(ON_RESET & status){
					status &=~ON_RESET;
					RST = 0;
		 			EN = 1;}
		 	}
		 	else{
				if(!(ON_RESET & status)){
		 			status |= ON_RESET;
					RST = 1;
		 			EN = 0;}		 		
			}
			
			// mode setting		 
		 	if(MODE){
		 		if(!(ON_TEST & status)){
		   			status |= ON_TEST;}
		 	}
		 	else{
		 		if(ON_TEST & status){
		 			status &=~ON_TEST;}
		 			}
			// data out

			if(!(ON_TEST & status)){			
				if(ON_RECEIVE & status){
				  tmp = sendByte(uart_receive_byte);
				  SBUF = tmp;
				  status &= ~ON_RECEIVE;; 
				}							
			}
			else{
				if(ON_RECEIVE & status){
					OUT_1 = 1;
					output = uart_receive_byte | 0xE0;
					status &= ~ON_RECEIVE;					
					P1 = output;
					input = P1;					
					SBUF = input;					
					while(TI);
					}
			}
		}	
					 	
	  }