/*
 * Decompiled with CFR 0.152.
 */
package cz.menigma.screens.messages;

import cz.menigma.BaseFormScreen;
import cz.menigma.Coder;
import cz.menigma.bo.ContactBO;
import cz.menigma.bo.EncryptKeyBO;
import cz.menigma.bo.IncomeMessageBO;
import cz.menigma.screens.contacts.ContactListScreen;
import cz.menigma.screens.messages.TextMessageScreen;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import javax.microedition.io.Connector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.wireless.messaging.Message;
import javax.wireless.messaging.MessageConnection;
import javax.wireless.messaging.TextMessage;

public class SendMessageScreen
extends BaseFormScreen
implements CommandListener {
    private ContactBO contact;
    private String messageContent;
    private String encryptedMessageContent;
    private Command cmdSend;
    private Command cmdSendTest;

    public SendMessageScreen(Coder coder, ContactBO contactBO, EncryptKeyBO encryptKeyBO, String string) {
        super(coder);
        this.contact = contactBO;
        this.messageContent = string;
        this.encryptedMessageContent = coder.getEncryptor().encrypt('a', encryptKeyBO, string);
        this.append((Item)new StringItem("Name:", contactBO.getContactName()));
        this.append((Item)new StringItem("Phone:", contactBO.getContactPhone()));
        this.append((Item)new StringItem("Key name:", encryptKeyBO.getKeyName()));
        this.append((Item)new StringItem("Length:", this.encryptedMessageContent.length() + " (" + this.encryptedMessageContent.getBytes().length + ")"));
        this.append((Item)new StringItem("Message:", this.encryptedMessageContent));
        this.cmdSend = new Command("Send", 4, 2);
        this.cmdSendTest = new Command("Send - Test", 4, 3);
        this.addCommand(this.cmdSend);
        this.addCommand(this.cmdSendTest);
    }

    private void sendSms() {
        try {
            String string = "sms://" + this.contact.getContactPhone() + ":" + this.owner.getPort();
            MessageConnection messageConnection = (MessageConnection)Connector.open((String)string);
            TextMessage textMessage = (TextMessage)messageConnection.newMessage("text");
            textMessage.setAddress(string);
            textMessage.setPayloadText(this.encryptedMessageContent);
            try {
                messageConnection.send((Message)textMessage);
            }
            catch (SecurityException securityException) {
                this.owner.showError(securityException);
            }
            messageConnection.close();
        }
        catch (IOException iOException) {
            this.owner.showError(iOException);
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.cmdBack) {
            this.owner.setScreen((Displayable)new ContactListScreen(this.owner, 0, this.messageContent));
        }
        if (command == this.cmdSend) {
            this.sendSms();
            this.owner.setScreen((Displayable)new TextMessageScreen(this.owner, this.messageContent + "(sent)"));
        }
        if (command == this.cmdSendTest) {
            IncomeMessageBO incomeMessageBO = new IncomeMessageBO();
            incomeMessageBO.setMessageContent(this.encryptedMessageContent);
            incomeMessageBO.setMessagePhone(this.contact.getContactPhone());
            Date date = new Date(System.currentTimeMillis());
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            incomeMessageBO.setMessageTime(calendar);
            try {
                this.owner.getDbBackendDAO().addDBRecordBO(incomeMessageBO);
            }
            catch (RecordStoreFullException recordStoreFullException) {
                this.owner.showError((Exception)((Object)recordStoreFullException));
            }
            catch (RecordStoreNotFoundException recordStoreNotFoundException) {
                this.owner.showError((Exception)((Object)recordStoreNotFoundException));
            }
            catch (RecordStoreException recordStoreException) {
                this.owner.showError((Exception)((Object)recordStoreException));
            }
            catch (IOException iOException) {
                this.owner.showError(iOException);
            }
            this.owner.setScreen((Displayable)new TextMessageScreen(this.owner, this.messageContent));
        }
    }
}

