/*
 * Decompiled with CFR 0.152.
 */
package cz.menigma.screens.messages;

import cz.menigma.BaseFormScreen;
import cz.menigma.Coder;
import cz.menigma.Utils;
import cz.menigma.bo.IncomeMessageBO;
import cz.menigma.screens.keys.KeyListScreen;
import cz.menigma.screens.messages.MessagesListScreen;
import java.util.Calendar;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;

public class SelectMessageScreen
extends BaseFormScreen
implements CommandListener {
    private Command cmdDelete;
    private Command cmdDecode;
    private int recordId;
    private IncomeMessageBO incomeMessage;

    public SelectMessageScreen(Coder coder, IncomeMessageBO incomeMessageBO) {
        super(coder);
        this.incomeMessage = incomeMessageBO;
        if (incomeMessageBO != null) {
            String string = coder.getDbBackendDAO().findContact(incomeMessageBO.getMessagePhone());
            this.append((Item)new StringItem("Odesilatel:", string));
            this.append((Item)new StringItem("Time:", Utils.formatDate(incomeMessageBO.getMessageTime()).toString()));
            this.append((Item)new StringItem("Length:", " " + incomeMessageBO.getMessageContent().length()));
            this.append((Item)new StringItem("Zprava:", incomeMessageBO.getMessageContent()));
        }
        this.cmdDelete = new Command("Delete", 4, 2);
        this.cmdDecode = new Command("Decode", 4, 3);
        this.addCommand(this.cmdDelete);
        this.addCommand(this.cmdDecode);
    }

    public SelectMessageScreen(Coder coder, int n) {
        super(coder);
        this.recordId = n;
        try {
            this.incomeMessage = (IncomeMessageBO)coder.getDbBackendDAO().getDBRecordBO("DB_INCOME_MESSAGES", n);
            if (this.incomeMessage != null) {
                this.append((Item)new StringItem("Sender:", this.incomeMessage.getMessagePhone()));
                Calendar calendar = this.incomeMessage.getMessageTime();
                String string = Utils.formatDate(calendar);
                this.append((Item)new StringItem("Time:", string));
                this.append((Item)new StringItem("Message:", this.incomeMessage.getMessageContent()));
            }
        }
        catch (RecordStoreFullException recordStoreFullException) {
            coder.showError((Exception)((Object)recordStoreFullException));
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            coder.showError((Exception)((Object)recordStoreNotFoundException));
        }
        catch (RecordStoreException recordStoreException) {
            coder.showError((Exception)((Object)recordStoreException));
        }
        this.cmdDelete = new Command("Delete", 4, 2);
        this.cmdDecode = new Command("Decode", 4, 3);
        this.addCommand(this.cmdDelete);
        this.addCommand(this.cmdDecode);
        this.setCommandListener(this);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.cmdBack) {
            this.owner.setScreen((Displayable)new MessagesListScreen(this.owner));
        }
        if (command == this.cmdDecode) {
            this.owner.setScreen((Displayable)new KeyListScreen(this.owner, this.incomeMessage));
        }
        if (command == this.cmdDelete) {
            try {
                this.owner.getDbBackendDAO().deleteDBRecordBO("DB_INCOME_MESSAGES", this.recordId);
            }
            catch (RecordStoreFullException recordStoreFullException) {
                this.owner.showError((Exception)((Object)recordStoreFullException));
            }
            catch (RecordStoreNotFoundException recordStoreNotFoundException) {
                this.owner.showError((Exception)((Object)recordStoreNotFoundException));
            }
            catch (RecordStoreException recordStoreException) {
                this.owner.showError((Exception)((Object)recordStoreException));
            }
            this.owner.setScreen((Displayable)new MessagesListScreen(this.owner));
        }
    }
}

