/*
 * Decompiled with CFR 0.152.
 */
package cz.menigma.screens.keys;

import cz.menigma.BaseFormScreen;
import cz.menigma.Coder;
import cz.menigma.bo.EncryptKeyBO;
import cz.menigma.screens.keys.KeyListScreen;
import cz.menigma.screens.keys.SendKeyScreen;
import java.io.IOException;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;

public class SelectKeyScreen
extends BaseFormScreen
implements CommandListener {
    private Command cmdSave;
    private Command cmdDelete;
    private TextField keyName;
    private TextField keyContent;
    private int recordId;
    private Command cmdSend;
    private EncryptKeyBO keyBO;
    private StringItem strLength;

    public SelectKeyScreen(Coder coder, int n) {
        super(coder);
        this.recordId = n;
        this.keyName = new TextField("Jmeno:", null, 100, 0);
        this.keyContent = new TextField("Klic:", null, 500, 0);
        try {
            this.keyBO = (EncryptKeyBO)coder.getDbBackendDAO().getDBRecordBO("DB_KEYS", n);
            if (this.keyBO != null) {
                this.keyName.setString(this.keyBO.getKeyName());
                this.keyContent.setString(this.keyBO.getKeyContent());
            }
        }
        catch (RecordStoreFullException recordStoreFullException) {
            coder.showError((Exception)((Object)recordStoreFullException));
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            coder.showError((Exception)((Object)recordStoreNotFoundException));
        }
        catch (RecordStoreException recordStoreException) {
            coder.showError((Exception)((Object)recordStoreException));
        }
        this.strLength = new StringItem("Delka:", this.keyContent.getString().length() + "(" + this.keyContent.getString().getBytes().length + "B)");
        this.append((Item)this.keyName);
        this.append((Item)this.strLength);
        this.append((Item)this.keyContent);
        this.cmdSend = new Command("Poslat", 4, 1);
        this.cmdSave = new Command("Ulozit", 4, 2);
        this.cmdDelete = new Command("Odstranit", 4, 3);
        this.addCommand(this.cmdSend);
        this.addCommand(this.cmdSave);
        this.addCommand(this.cmdDelete);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.cmdBack) {
            this.owner.setScreen((Displayable)new KeyListScreen(this.owner));
        }
        if (command == this.cmdSave) {
            try {
                EncryptKeyBO encryptKeyBO = (EncryptKeyBO)this.owner.getDbBackendDAO().getDBRecordBO("DB_KEYS", this.recordId);
                encryptKeyBO.setKeyContent(this.keyContent.getString());
                encryptKeyBO.setKeyName(this.keyName.getString());
                this.owner.getDbBackendDAO().updateDBRecordBO(encryptKeyBO);
                this.owner.setScreen((Displayable)new KeyListScreen(this.owner));
            }
            catch (RecordStoreFullException recordStoreFullException) {
                this.owner.showError((Exception)((Object)recordStoreFullException));
            }
            catch (RecordStoreNotFoundException recordStoreNotFoundException) {
                this.owner.showError((Exception)((Object)recordStoreNotFoundException));
            }
            catch (RecordStoreException recordStoreException) {
                this.owner.showError((Exception)((Object)recordStoreException));
            }
            catch (IOException iOException) {
                this.owner.showError(iOException);
            }
        }
        if (command == this.cmdSend) {
            this.owner.setScreen((Displayable)new SendKeyScreen(this.owner, this.keyBO));
        }
        if (command == this.cmdDelete) {
            try {
                this.owner.getDbBackendDAO().deleteDBRecordBO("DB_KEYS", this.recordId);
            }
            catch (RecordStoreFullException recordStoreFullException) {
                this.owner.showError((Exception)((Object)recordStoreFullException));
            }
            catch (RecordStoreNotFoundException recordStoreNotFoundException) {
                this.owner.showError((Exception)((Object)recordStoreNotFoundException));
            }
            catch (RecordStoreException recordStoreException) {
                this.owner.showError((Exception)((Object)recordStoreException));
            }
            this.owner.setScreen((Displayable)new KeyListScreen(this.owner));
        }
    }
}

