/*
 * Decompiled with CFR 0.152.
 */
package cz.menigma.screens.keys;

import cz.menigma.BaseListScreen;
import cz.menigma.Coder;
import cz.menigma.bo.ContactBO;
import cz.menigma.bo.EncryptKeyBO;
import cz.menigma.bo.IncomeMessageBO;
import cz.menigma.persist.dao.DatabaseException;
import cz.menigma.screens.MenuScreen;
import cz.menigma.screens.keys.AddKeyScreen;
import cz.menigma.screens.keys.SelectKeyScreen;
import cz.menigma.screens.messages.DecodedMessageScreen;
import cz.menigma.screens.messages.SendMessageScreen;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;

public class KeyListScreen
extends BaseListScreen
implements CommandListener {
    final short TYPE_EDIT;
    final short TYPE_SELECT_ENCODE;
    final short TYPE_SELECT_DECODE = (short)2;
    private Command cmdNewkey;
    private Vector mappingId;
    private ContactBO contact;
    private String messageContent;
    private Command cmdDecode;
    private short type;
    private IncomeMessageBO incomeMessage;

    public KeyListScreen(Coder coder) {
        super(coder, 3);
        this.TYPE_EDIT = 0;
        this.TYPE_SELECT_ENCODE = 1;
        this.type = 0;
        this.loadKeys();
        this.cmdNewkey = new Command("Novy klic", 4, 3);
        this.addCommand(this.cmdNewkey);
    }

    public KeyListScreen(Coder coder, ContactBO contactBO, String string) {
        super(coder, 3);
        this.TYPE_EDIT = 0;
        this.TYPE_SELECT_ENCODE = 1;
        this.type = 1;
        this.contact = contactBO;
        this.messageContent = string;
        this.loadKeys();
    }

    public KeyListScreen(Coder coder, IncomeMessageBO incomeMessageBO) {
        super(coder, 3);
        this.TYPE_EDIT = 0;
        this.TYPE_SELECT_ENCODE = 1;
        this.type = (short)2;
        this.incomeMessage = incomeMessageBO;
        this.loadKeys();
        this.cmdDecode = new Command("Dekodovat", 2, 1);
        this.addCommand(this.cmdDecode);
    }

    private void loadKeys() {
        try {
            EncryptKeyBO[] encryptKeyBOArray = this.owner.getDbBackendDAO().getAllKeysBO();
            this.mappingId = new Vector();
            for (int i = 0; i < encryptKeyBOArray.length; ++i) {
                EncryptKeyBO encryptKeyBO = encryptKeyBOArray[i];
                this.append(encryptKeyBO.getKeyName(), null);
                this.mappingId.addElement(new Integer(encryptKeyBO.getRecordId()));
            }
        }
        catch (DatabaseException databaseException) {
            databaseException.printStackTrace();
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.cmdBack) {
            MenuScreen menuScreen = new MenuScreen(this.owner);
            menuScreen.setSelectedIndex(menuScreen.getKeysIdx());
            this.owner.setScreen((Displayable)menuScreen);
        }
        if (command == this.cmdNewkey) {
            this.owner.setScreen((Displayable)new AddKeyScreen(this.owner));
        }
        if (command.getCommandType() == 1) {
            EncryptKeyBO encryptKeyBO;
            if (this.type == 0) {
                int n = (Integer)this.mappingId.elementAt(this.getSelectedIndex());
                this.owner.setScreen((Displayable)new SelectKeyScreen(this.owner, n));
            }
            if (this.type == 1) {
                int n = (Integer)this.mappingId.elementAt(this.getSelectedIndex());
                try {
                    encryptKeyBO = (EncryptKeyBO)this.owner.getDbBackendDAO().getDBRecordBO("DB_KEYS", n);
                    this.owner.setScreen((Displayable)new SendMessageScreen(this.owner, this.contact, encryptKeyBO, this.messageContent));
                }
                catch (RecordStoreFullException recordStoreFullException) {
                    this.owner.showError((Exception)((Object)recordStoreFullException));
                }
                catch (RecordStoreNotFoundException recordStoreNotFoundException) {
                    this.owner.showError((Exception)((Object)recordStoreNotFoundException));
                }
                catch (RecordStoreException recordStoreException) {
                    this.owner.showError((Exception)((Object)recordStoreException));
                }
            }
            if (this.type == 2) {
                int n = (Integer)this.mappingId.elementAt(this.getSelectedIndex());
                try {
                    encryptKeyBO = (EncryptKeyBO)this.owner.getDbBackendDAO().getDBRecordBO("DB_KEYS", n);
                    this.owner.setScreen((Displayable)new DecodedMessageScreen(this.owner, encryptKeyBO, this.incomeMessage));
                }
                catch (RecordStoreFullException recordStoreFullException) {
                    this.owner.showError((Exception)((Object)recordStoreFullException));
                }
                catch (RecordStoreNotFoundException recordStoreNotFoundException) {
                    this.owner.showError((Exception)((Object)recordStoreNotFoundException));
                }
                catch (RecordStoreException recordStoreException) {
                    this.owner.showError((Exception)((Object)recordStoreException));
                }
            }
        }
    }
}

