/*
 * Decompiled with CFR 0.152.
 */
package cz.menigma.screens.contacts;

import cz.menigma.BaseFormScreen;
import cz.menigma.Coder;
import cz.menigma.bo.ContactBO;
import cz.menigma.screens.contacts.ContactListScreen;
import java.io.IOException;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;

public class SelectedContactScreen
extends BaseFormScreen
implements CommandListener {
    private TextField phoneName;
    private TextField phoneNumber;
    private Command cmdSave;
    private Command cmdDelete;
    private int idx;
    private ContactBO contact = null;

    public SelectedContactScreen(Coder coder, int n) {
        super(coder);
        try {
            this.contact = (ContactBO)coder.getDbBackendDAO().getDBRecordBO("DB_CONTACTS", n);
        }
        catch (RecordStoreFullException recordStoreFullException) {
            coder.showError((Exception)((Object)recordStoreFullException));
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            coder.showError((Exception)((Object)recordStoreNotFoundException));
        }
        catch (RecordStoreException recordStoreException) {
            coder.showError((Exception)((Object)recordStoreException));
        }
        this.owner = coder;
        this.idx = n;
        this.phoneName = new TextField("Jmeno:", this.contact.getContactName(), 12, 0);
        this.phoneNumber = new TextField("Cislo:", this.contact.getContactPhone(), 12, 2);
        this.append((Item)this.phoneName);
        this.append((Item)this.phoneNumber);
        this.cmdSave = new Command("Ulozit", 4, 2);
        this.cmdDelete = new Command("Odstranit", 4, 3);
        this.addCommand(this.cmdSave);
        this.addCommand(this.cmdDelete);
        this.setTitle("Edit");
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.cmdBack) {
            this.owner.setScreen((Displayable)new ContactListScreen(this.owner, this.idx));
        }
        if (command == this.cmdSave) {
            try {
                ContactBO contactBO = (ContactBO)this.owner.getDbBackendDAO().getDBRecordBO("DB_CONTACTS", this.idx);
                contactBO.setContactName(this.phoneName.getString());
                contactBO.setContactPhone(this.phoneNumber.getString());
                System.out.println(this.idx + " / " + contactBO.getRecordId());
                this.owner.getDbBackendDAO().updateDBRecordBO(contactBO);
            }
            catch (RecordStoreFullException recordStoreFullException) {
                this.owner.showError((Exception)((Object)recordStoreFullException));
            }
            catch (RecordStoreNotFoundException recordStoreNotFoundException) {
                this.owner.showError((Exception)((Object)recordStoreNotFoundException));
            }
            catch (RecordStoreException recordStoreException) {
                this.owner.showError((Exception)((Object)recordStoreException));
            }
            catch (IOException iOException) {
                this.owner.showError(iOException);
            }
            this.owner.setScreen((Displayable)new ContactListScreen(this.owner, this.idx));
        }
        if (command == this.cmdDelete) {
            try {
                this.owner.getDbBackendDAO().deleteDBRecordBO("DB_CONTACTS", this.idx);
            }
            catch (RecordStoreFullException recordStoreFullException) {
                this.owner.showError((Exception)((Object)recordStoreFullException));
            }
            catch (RecordStoreNotFoundException recordStoreNotFoundException) {
                this.owner.showError((Exception)((Object)recordStoreNotFoundException));
            }
            catch (RecordStoreException recordStoreException) {
                this.owner.showError((Exception)((Object)recordStoreException));
            }
            this.owner.setScreen((Displayable)new ContactListScreen(this.owner, this.idx));
        }
    }
}

