/*
 * Decompiled with CFR 0.152.
 */
package cz.menigma.screens.contacts;

import cz.menigma.BaseListScreen;
import cz.menigma.Coder;
import cz.menigma.bo.ContactBO;
import cz.menigma.persist.dao.DatabaseException;
import cz.menigma.screens.MenuScreen;
import cz.menigma.screens.contacts.AddContactScreen;
import cz.menigma.screens.contacts.SelectedContactScreen;
import cz.menigma.screens.keys.KeyListScreen;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;

public class ContactListScreen
extends BaseListScreen
implements CommandListener {
    public static final short SELECT = 0;
    public static final short DELETE = 1;
    public static final short TYPE_SELECT = 0;
    public static final short TYPE_EDIT = 1;
    private short type;
    private Command cmdAdd;
    private Vector mappingId;
    private String messageContent;

    public ContactListScreen(Coder coder, int n) {
        super(coder, 3);
        this.cmdAdd = new Command("Novy kontakt", 4, 3);
        this.addCommand(this.cmdAdd);
        this.type = 1;
        this.loadContacts();
    }

    public ContactListScreen(Coder coder, int n, String string) {
        super(coder, 3);
        this.messageContent = string;
        this.type = 0;
        this.loadContacts();
    }

    public void loadContacts() {
        try {
            ContactBO[] contactBOArray = this.owner.getDbBackendDAO().getAllContactsBO();
            this.mappingId = new Vector();
            for (int i = 0; i < contactBOArray.length; ++i) {
                ContactBO contactBO = contactBOArray[i];
                this.mappingId.addElement(new Integer(contactBO.getRecordId()));
                this.append(contactBO.getRecordId() + "-" + contactBO.getContactName(), null);
            }
        }
        catch (DatabaseException databaseException) {
            this.owner.showError(databaseException);
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.cmdBack) {
            MenuScreen menuScreen = new MenuScreen(this.owner);
            menuScreen.setSelectedIndex(menuScreen.getContactsIdx());
            this.owner.setScreen((Displayable)menuScreen);
        }
        if (command == this.cmdAdd) {
            this.owner.setScreen((Displayable)new AddContactScreen(this.owner));
        }
        if (command.getCommandType() == 1 && this.type == 1) {
            int n = (Integer)this.mappingId.elementAt(this.getSelectedIndex());
            this.owner.setScreen((Displayable)new SelectedContactScreen(this.owner, n));
        }
        if (this.type == 0) {
            int n = (Integer)this.mappingId.elementAt(this.getSelectedIndex());
            try {
                ContactBO contactBO = (ContactBO)this.owner.getDbBackendDAO().getDBRecordBO("DB_CONTACTS", n);
                this.owner.setScreen((Displayable)new KeyListScreen(this.owner, contactBO, this.messageContent));
            }
            catch (RecordStoreFullException recordStoreFullException) {
                this.owner.showError((Exception)((Object)recordStoreFullException));
            }
            catch (RecordStoreNotFoundException recordStoreNotFoundException) {
                this.owner.showError((Exception)((Object)recordStoreNotFoundException));
            }
            catch (RecordStoreException recordStoreException) {
                this.owner.showError((Exception)((Object)recordStoreException));
            }
        }
    }
}

