/*
 * Decompiled with CFR 0.152.
 */
package cz.menigma.persist.impl;

import cz.menigma.bo.ContactBO;
import cz.menigma.bo.ContactComparator;
import cz.menigma.bo.ContactFilter;
import cz.menigma.bo.EncryptKeyBO;
import cz.menigma.bo.IncomeMessageBO;
import cz.menigma.bo.KeyComparator;
import cz.menigma.bo.MessageComparator;
import cz.menigma.bo.SettingsBO;
import cz.menigma.persist.bo.DBRecordBO;
import cz.menigma.persist.dao.DatabaseException;
import cz.menigma.persist.dao.IDBBackendDAO;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordComparator;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordFilter;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class DBBackendImpl
implements IDBBackendDAO {
    public DBBackendImpl() {
        ContactBO.setDbName("DB_CONTACTS");
        EncryptKeyBO.setDbName("DB_KEYS");
        IncomeMessageBO.setDbName("DB_INCOME_MESSAGES");
    }

    public DBRecordBO[] getAllDBRecordBO(String string) throws RecordStoreFullException, RecordStoreNotFoundException, RecordStoreException {
        RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
        DBRecordBO[] dBRecordBOArray = null;
        RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, true);
        Vector vector = new Vector();
        if (string.equals("DB_CONTACTS")) {
            dBRecordBOArray = this.loadContacts(recordStore, recordEnumeration, vector);
        }
        if (string.equals("DB_INCOME_MESSAGES")) {
            dBRecordBOArray = this.loadMessages(recordStore, recordEnumeration, vector);
        }
        if (string.equals("DB_KEYS")) {
            dBRecordBOArray = this.loadKeys(recordStore, recordEnumeration, vector);
        }
        if (string.equals("DB_SETTINGS")) {
            dBRecordBOArray = this.loadSettings(recordStore, recordEnumeration, vector);
        }
        recordStore.closeRecordStore();
        return dBRecordBOArray;
    }

    private DBRecordBO[] loadSettings(RecordStore recordStore, RecordEnumeration recordEnumeration, Vector vector) throws RecordStoreNotOpenException, RecordStoreException {
        while (recordEnumeration.hasNextElement()) {
            int n = recordEnumeration.nextRecordId();
            SettingsBO settingsBO = new SettingsBO(recordStore.getRecord(n));
            settingsBO.setRecordId(n);
            vector.addElement(settingsBO);
        }
        Object[] objectArray = new SettingsBO[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private EncryptKeyBO[] loadKeys(RecordStore recordStore, RecordEnumeration recordEnumeration, Vector vector) throws InvalidRecordIDException, RecordStoreNotOpenException, RecordStoreException {
        while (recordEnumeration.hasNextElement()) {
            int n = recordEnumeration.nextRecordId();
            EncryptKeyBO encryptKeyBO = new EncryptKeyBO(recordStore.getRecord(n));
            encryptKeyBO.setRecordId(n);
            vector.addElement(encryptKeyBO);
        }
        Object[] objectArray = new EncryptKeyBO[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private IncomeMessageBO[] loadMessages(RecordStore recordStore, RecordEnumeration recordEnumeration, Vector vector) throws InvalidRecordIDException, RecordStoreNotOpenException, RecordStoreException {
        while (recordEnumeration.hasNextElement()) {
            int n = recordEnumeration.nextRecordId();
            IncomeMessageBO incomeMessageBO = new IncomeMessageBO(recordStore.getRecord(n));
            incomeMessageBO.setRecordId(n);
            vector.addElement(incomeMessageBO);
        }
        Object[] objectArray = new IncomeMessageBO[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private ContactBO[] loadContacts(RecordStore recordStore, RecordEnumeration recordEnumeration, Vector vector) throws InvalidRecordIDException, RecordStoreNotOpenException, RecordStoreException {
        while (recordEnumeration.hasNextElement()) {
            int n = recordEnumeration.nextRecordId();
            ContactBO contactBO = new ContactBO(recordStore.getRecord(n));
            contactBO.setRecordId(n);
            vector.addElement(contactBO);
        }
        Object[] objectArray = new ContactBO[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void addDBRecordBO(DBRecordBO dBRecordBO) throws RecordStoreFullException, RecordStoreNotFoundException, RecordStoreException, IOException {
        RecordStore recordStore = RecordStore.openRecordStore((String)dBRecordBO.getDbName(), (boolean)true);
        recordStore.addRecord(dBRecordBO.getBytes(), 0, dBRecordBO.getBytes().length);
        recordStore.closeRecordStore();
    }

    public void deleteDBRecordBO(String string, int n) throws RecordStoreFullException, RecordStoreNotFoundException, RecordStoreException {
        RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
        recordStore.deleteRecord(n);
        recordStore.closeRecordStore();
    }

    public DBRecordBO getDBRecordBO(String string, int n) throws RecordStoreFullException, RecordStoreNotFoundException, RecordStoreException {
        RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
        DBRecordBO dBRecordBO = null;
        if (string == "DB_CONTACTS") {
            dBRecordBO = new ContactBO(recordStore.getRecord(n));
        }
        if (string == "DB_INCOME_MESSAGES") {
            dBRecordBO = new IncomeMessageBO(recordStore.getRecord(n));
        }
        if (string == "DB_KEYS") {
            dBRecordBO = new EncryptKeyBO(recordStore.getRecord(n));
        }
        recordStore.closeRecordStore();
        dBRecordBO.setRecordId(n);
        return dBRecordBO;
    }

    public ContactBO[] getAllContactsBO() throws DatabaseException {
        ContactBO[] contactBOArray = null;
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"DB_CONTACTS", (boolean)true);
            RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, (RecordComparator)new ContactComparator(), true);
            Vector vector = new Vector();
            contactBOArray = this.loadContacts(recordStore, recordEnumeration, vector);
            recordStore.closeRecordStore();
        }
        catch (RecordStoreFullException recordStoreFullException) {
            throw new DatabaseException((Exception)((Object)recordStoreFullException));
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            throw new DatabaseException((Exception)((Object)recordStoreNotFoundException));
        }
        catch (RecordStoreException recordStoreException) {
            throw new DatabaseException((Exception)((Object)recordStoreException));
        }
        return contactBOArray;
    }

    public IncomeMessageBO[] getAllIncomeMessagesBO() throws DatabaseException {
        IncomeMessageBO[] incomeMessageBOArray = null;
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"DB_INCOME_MESSAGES", (boolean)true);
            RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, (RecordComparator)new MessageComparator(), true);
            Vector vector = new Vector();
            incomeMessageBOArray = this.loadMessages(recordStore, recordEnumeration, vector);
            recordStore.closeRecordStore();
        }
        catch (RecordStoreFullException recordStoreFullException) {
            throw new DatabaseException((Exception)((Object)recordStoreFullException));
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            throw new DatabaseException((Exception)((Object)recordStoreNotFoundException));
        }
        catch (RecordStoreException recordStoreException) {
            throw new DatabaseException((Exception)((Object)recordStoreException));
        }
        return incomeMessageBOArray;
    }

    public EncryptKeyBO[] getAllKeysBO() throws DatabaseException {
        EncryptKeyBO[] encryptKeyBOArray = null;
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"DB_KEYS", (boolean)true);
            RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, (RecordComparator)new KeyComparator(), true);
            Vector vector = new Vector();
            encryptKeyBOArray = this.loadKeys(recordStore, recordEnumeration, vector);
            recordStore.closeRecordStore();
        }
        catch (RecordStoreFullException recordStoreFullException) {
            throw new DatabaseException((Exception)((Object)recordStoreFullException));
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            throw new DatabaseException((Exception)((Object)recordStoreNotFoundException));
        }
        catch (RecordStoreException recordStoreException) {
            throw new DatabaseException((Exception)((Object)recordStoreException));
        }
        return encryptKeyBOArray;
    }

    public String findContact(String string) {
        ContactBO contactBO;
        if (string.length() > 9) {
            int n = string.length();
            string = string.substring(n - 9, n);
        }
        try {
            contactBO = this.findContactBO(string);
        }
        catch (DatabaseException databaseException) {
            return string;
        }
        if (contactBO != null) {
            return contactBO.getContactName();
        }
        return string;
    }

    private ContactBO findContactBO(String string) throws DatabaseException {
        ContactBO contactBO = null;
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"DB_CONTACTS", (boolean)true);
            RecordEnumeration recordEnumeration = recordStore.enumerateRecords((RecordFilter)new ContactFilter(string), (RecordComparator)new KeyComparator(), true);
            if (recordEnumeration.hasNextElement()) {
                contactBO = new ContactBO(recordEnumeration.nextRecord());
            }
            recordStore.closeRecordStore();
        }
        catch (RecordStoreFullException recordStoreFullException) {
            throw new DatabaseException((Exception)((Object)recordStoreFullException));
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            throw new DatabaseException((Exception)((Object)recordStoreNotFoundException));
        }
        catch (RecordStoreException recordStoreException) {
            throw new DatabaseException((Exception)((Object)recordStoreException));
        }
        return contactBO;
    }

    public SettingsBO getSettings() throws RecordStoreFullException, RecordStoreNotFoundException, RecordStoreException, IOException {
        SettingsBO settingsBO;
        DBRecordBO[] dBRecordBOArray = this.getAllDBRecordBO("DB_SETTINGS");
        if (dBRecordBOArray.length == 0) {
            settingsBO = new SettingsBO();
            SettingsBO.setDbName("DB_SETTINGS");
            this.addDBRecordBO(settingsBO);
        }
        dBRecordBOArray = new DBRecordBO[]{new SettingsBO()};
        settingsBO = (SettingsBO)dBRecordBOArray[0];
        return settingsBO;
    }

    public void getUpdateSettings(SettingsBO settingsBO) {
    }

    public void updateDBRecordBO(DBRecordBO dBRecordBO) throws RecordStoreFullException, RecordStoreNotFoundException, RecordStoreException, IOException {
        RecordStore recordStore = RecordStore.openRecordStore((String)dBRecordBO.getDbName(), (boolean)true);
        recordStore.setRecord(dBRecordBO.getRecordId(), dBRecordBO.getBytes(), 0, dBRecordBO.getBytes().length);
        recordStore.closeRecordStore();
    }
}

