/*
 * Decompiled with CFR 0.152.
 */
package cz.menigma.bluetooth;

import cz.menigma.Coder;
import cz.menigma.bo.EncryptKeyBO;
import cz.menigma.screens.keys.ConfirmIncomeKeyScreen;
import cz.menigma.screens.messages.MessageScreen;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import javax.bluetooth.DataElement;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.ServiceRecord;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.io.StreamConnectionNotifier;
import javax.microedition.lcdui.Displayable;

public class BluetoothServer
implements Runnable {
    private String serversConnString = "btspp://localhost:3B9FA89520078C303355AAA694238F07;authenticate=false;encrypt=false";
    private Coder owner;
    private Thread serverThread;
    private static boolean showInfo = true;
    private boolean stop;
    private static final int IMAGES_NAMES_ATTRIBUTE_ID = 17185;

    public boolean isStop() {
        return this.stop;
    }

    public BluetoothServer(Coder coder) {
        this.owner = coder;
        this.stop = true;
        this.serverThread = new Thread(this);
        this.serverThread.start();
    }

    public void run() {
        try {
            BluetoothServer bluetoothServer = this;
            synchronized (bluetoothServer) {
                while (true) {
                    if (this.stop) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            this.owner.setScreen((Displayable)new MessageScreen(this.owner, "Server running.."));
                        }
                        continue;
                    }
                    try {
                        this.keyServerRun();
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        this.owner.setScreen((Displayable)new MessageScreen(this.owner, "Server stopped.."));
                    }
                    catch (Exception exception) {
                        if (!(exception instanceof InterruptedException)) continue;
                        this.owner.setScreen((Displayable)new MessageScreen(this.owner, "Server stopped.."));
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private void keyServerRun() throws InterruptedIOException {
        try {
            StreamConnectionNotifier streamConnectionNotifier = (StreamConnectionNotifier)Connector.open((String)this.serversConnString);
            LocalDevice localDevice = LocalDevice.getLocalDevice();
            ServiceRecord serviceRecord = localDevice.getRecord((Connection)streamConnectionNotifier);
            DataElement dataElement = new DataElement(48);
            serviceRecord.setAttributeValue(17185, dataElement);
            if (showInfo) {
                this.owner.setScreen((Displayable)new MessageScreen(this.owner, "Server running.."));
                showInfo = false;
            }
            StreamConnection streamConnection = streamConnectionNotifier.acceptAndOpen();
            DataInputStream dataInputStream = streamConnection.openDataInputStream();
            EncryptKeyBO encryptKeyBO = new EncryptKeyBO();
            String string = dataInputStream.readUTF();
            encryptKeyBO.setKeyName(string);
            string = dataInputStream.readUTF();
            encryptKeyBO.setKeyContent(string);
            dataInputStream.close();
            streamConnectionNotifier.close();
            this.owner.setScreen((Displayable)new ConfirmIncomeKeyScreen(this.owner, null, encryptKeyBO, false));
        }
        catch (InterruptedIOException interruptedIOException) {
            throw interruptedIOException;
        }
        catch (IOException iOException) {
            this.owner.setMessageContent("Error..");
        }
    }

    public void onRun(boolean bl) {
        if (bl) {
            if (this.stop) {
                this.stop = false;
                this.serverThread.interrupt();
            }
        } else if (!this.stop) {
            this.stop = true;
            this.serverThread.interrupt();
        }
    }
}

