/*
 * Decompiled with CFR 0.152.
 */
package cz.menigma.bluetooth;

import cz.menigma.BaseListScreen;
import cz.menigma.Coder;
import cz.menigma.bo.EncryptKeyBO;
import cz.menigma.bo.KeyTosendBO;
import cz.menigma.screens.keys.KeyListScreen;
import cz.menigma.screens.keys.KeySenderScreen;
import java.io.IOException;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;

public class BluetoothClient
extends BaseListScreen
implements DiscoveryListener,
Runnable {
    private LocalDevice localDevice;
    private Thread clientThread;
    private DiscoveryAgent discoveryAgent;
    private Vector remoteDevices;
    private Vector deviceClasses;
    private Vector coderKeyServices;
    private EncryptKeyBO keyBO;
    private static final int IMAGES_NAMES_ATTRIBUTE_ID = 17185;

    public BluetoothClient(Coder coder, EncryptKeyBO encryptKeyBO) {
        super(coder, 3);
        this.owner = coder;
        this.keyBO = encryptKeyBO;
        this.remoteDevices = new Vector();
        this.deviceClasses = new Vector();
        this.coderKeyServices = new Vector();
        this.append("Devices:", null);
        this.coderKeyServices.addElement(null);
        this.clientThread = new Thread(this);
        this.clientThread.start();
    }

    public void deviceDiscovered(RemoteDevice remoteDevice, DeviceClass deviceClass) {
        this.remoteDevices.addElement(remoteDevice);
        this.deviceClasses.addElement(deviceClass);
    }

    public void inquiryCompleted(int n) {
        if (n == 0) {
            this.append("Device searching finished", null);
            this.coderKeyServices.addElement(null);
        }
        if (n == 5) {
            this.append("Device searching terminated", null);
            this.coderKeyServices.addElement(null);
        }
        if (n == 7) {
            this.append("Device searching failed", null);
            this.coderKeyServices.addElement(null);
        }
        UUID uUID = new UUID("3B9FA89520078C303355AAA694238F07", false);
        UUID[] uUIDArray = new UUID[]{new UUID(4353L), uUID};
        for (int i = 0; i < this.remoteDevices.size(); ++i) {
            try {
                this.discoveryAgent.searchServices(new int[]{17185}, uUIDArray, (RemoteDevice)this.remoteDevices.elementAt(i), (DiscoveryListener)this);
                continue;
            }
            catch (BluetoothStateException bluetoothStateException) {
                this.append(bluetoothStateException.getMessage(), null);
                this.coderKeyServices.addElement(null);
            }
        }
    }

    public void serviceSearchCompleted(int n, int n2) {
        this.append("service finding finished", null);
        this.coderKeyServices.addElement(null);
    }

    public void servicesDiscovered(int n, ServiceRecord[] serviceRecordArray) {
        ServiceRecord serviceRecord = serviceRecordArray[0];
        try {
            String string = serviceRecord.getHostDevice().getFriendlyName(true);
            this.append(string, null);
            this.coderKeyServices.addElement(serviceRecord);
        }
        catch (IOException iOException) {
            this.append(iOException.getMessage(), null);
            this.coderKeyServices.addElement(null);
        }
    }

    public void run() {
        try {
            this.localDevice = LocalDevice.getLocalDevice();
            this.discoveryAgent = this.localDevice.getDiscoveryAgent();
            this.discoveryAgent.startInquiry(10390323, (DiscoveryListener)this);
        }
        catch (BluetoothStateException bluetoothStateException) {
            this.append("Error in run()", null);
            this.coderKeyServices.addElement(null);
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.cmdBack) {
            this.owner.setScreen((Displayable)new KeyListScreen(this.owner));
            return;
        }
        int n = this.getSelectedIndex();
        ServiceRecord serviceRecord = (ServiceRecord)this.coderKeyServices.elementAt(n);
        if (serviceRecord == null) {
            return;
        }
        KeyTosendBO keyTosendBO = new KeyTosendBO();
        keyTosendBO.setReceiverService(serviceRecord);
        keyTosendBO.setKey(this.keyBO);
        this.owner.setScreen((Displayable)new KeySenderScreen(this.owner, keyTosendBO));
    }
}

