/*
 * Decompiled with CFR 0.152.
 */
package cz.menigma;

import cz.menigma.bluetooth.BluetoothServer;
import cz.menigma.bo.IncomeMessageBO;
import cz.menigma.encryptor.EncryptorFactory;
import cz.menigma.encryptor.IEncryptor;
import cz.menigma.persist.dao.IDBBackendDAO;
import cz.menigma.persist.impl.DBBackendImpl;
import cz.menigma.screens.MenuScreen;
import cz.menigma.screens.messages.SelectMessageScreen;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.PushRegistry;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.wireless.messaging.MessageConnection;
import javax.wireless.messaging.MessageListener;
import javax.wireless.messaging.TextMessage;

public class Coder
extends MIDlet
implements MessageListener,
Runnable {
    private Display display;
    private String title;
    private String messageContent;
    private boolean run = true;
    private IncomeMessageBO incomingMessage;
    private Vector listeners;
    private IDBBackendDAO dbBackendDAO;
    private BluetoothServer bluetoothServer;
    private Displayable currentScreen;
    private IEncryptor encryptor = EncryptorFactory.getEncryptor();

    public boolean isKeyServerRunning() {
        return !this.bluetoothServer.isStop();
    }

    public void reloadLastScren() {
        this.setScreen(this.currentScreen);
    }

    public Displayable getCurrentScreen() {
        return this.currentScreen;
    }

    protected void setCurrentScreen(Displayable displayable) {
        this.currentScreen = displayable;
    }

    private void showError(String string) {
    }

    public IEncryptor getEncryptor() {
        return this.encryptor;
    }

    public void onRunKeyServer(boolean bl) {
        this.bluetoothServer.onRun(bl);
    }

    public Coder() {
        this.dbBackendDAO = new DBBackendImpl();
        this.listeners = new Vector();
        String[] stringArray = PushRegistry.listConnections((boolean)true);
        if (stringArray.length != 0) {
            for (int i = stringArray.length - 1; i >= 0; --i) {
                try {
                    MessageConnection messageConnection = (MessageConnection)Connector.open((String)stringArray[i]);
                    messageConnection.setMessageListener((MessageListener)this);
                    this.listeners.addElement(messageConnection);
                    continue;
                }
                catch (SecurityException securityException) {
                    this.showError(" Access to receive message is refused. Will not be able to receive the anser");
                    continue;
                }
                catch (IOException iOException) {
                    this.showError(" Error reading SMS\n");
                }
            }
        } else {
            stringArray = PushRegistry.listConnections((boolean)false);
            this.showError(" User started the application. " + stringArray.length + " connections registered.\n");
            for (int i = stringArray.length - 1; i >= 0; --i) {
                try {
                    MessageConnection messageConnection = (MessageConnection)Connector.open((String)stringArray[i]);
                    messageConnection.setMessageListener((MessageListener)this);
                    this.listeners.addElement(messageConnection);
                    continue;
                }
                catch (SecurityException securityException) {
                    this.showError("Access to receive message is refused. Will not be able to receive the anser");
                    continue;
                }
                catch (IOException iOException) {
                    this.showError(" Error reading SMS\n");
                }
            }
        }
        this.bluetoothServer = new BluetoothServer(this);
        new Thread(this).start();
    }

    public void init() {
        this.display = Display.getDisplay((MIDlet)this);
        this.display.setCurrent((Displayable)new MenuScreen(this));
    }

    protected void destroyApp(boolean bl) throws MIDletStateChangeException {
    }

    protected void pauseApp() {
    }

    protected void startApp() throws MIDletStateChangeException {
    }

    public void exit() {
        this.run = false;
    }

    public void setScreen(Displayable displayable) {
        this.display.setCurrent(displayable);
    }

    public String getMessageContent() {
        return this.messageContent;
    }

    public void setMessageContent(String string) {
        this.messageContent = string;
    }

    public void notifyIncomingMessage(MessageConnection messageConnection) {
        try {
            TextMessage textMessage = (TextMessage)messageConnection.receive();
            this.incomingMessage = new IncomeMessageBO();
            this.incomingMessage.setMessagePhone(textMessage.getAddress());
            Date date = textMessage.getTimestamp();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            this.incomingMessage.setMessageTime(calendar);
            this.incomingMessage.setMessageContent(textMessage.getPayloadText());
            if (this.incomingMessage.getMessageContent() == null) {
                this.incomingMessage.setMessageContent("--empty--");
            }
        }
        catch (SecurityException securityException) {
            this.showError(securityException);
        }
        catch (Exception exception) {
            this.showError(exception);
        }
    }

    public void run() {
        this.init();
        while (this.run) {
            if (this.incomingMessage == null) continue;
            try {
                this.getDbBackendDAO().addDBRecordBO(this.incomingMessage);
            }
            catch (RecordStoreFullException recordStoreFullException) {
                this.showError((Exception)((Object)recordStoreFullException));
            }
            catch (RecordStoreNotFoundException recordStoreNotFoundException) {
                this.showError((Exception)((Object)recordStoreNotFoundException));
            }
            catch (RecordStoreException recordStoreException) {
                this.showError((Exception)((Object)recordStoreException));
            }
            catch (IOException iOException) {
                this.showError(iOException);
            }
            this.display.setCurrent((Displayable)new SelectMessageScreen(this, this.incomingMessage));
            this.incomingMessage = null;
        }
        try {
            this.destroyApp(false);
            this.notifyDestroyed();
        }
        catch (MIDletStateChangeException mIDletStateChangeException) {
            this.showError((Exception)((Object)mIDletStateChangeException));
        }
    }

    public String getTitle() {
        return this.title;
    }

    public IDBBackendDAO getDbBackendDAO() {
        return this.dbBackendDAO;
    }

    public void showError(Exception exception) {
        exception.printStackTrace();
    }

    public void showAlert(Alert alert, Displayable displayable) {
        alert.setTimeout(4000);
        this.display.setCurrent(alert, displayable);
    }

    public String getPort() {
        return String.valueOf(51978);
    }
}

